//////////////////////////////////////////////
//	File:		"CMainMenuState.h"
//
//	Author:		Jason Stegner (JS)
//
//	Purpose:	Gives the user a central hub to 
//				access the other states of the game.
//////////////////////////////////////////////

#ifndef CMAINMENUSTATE_H_
#define CMAINMENUSTATE_H_

#include "IGameState.h"
#include <windows.h>
#include "CBitmapFont.h"
#include "CBitmapFontManager.h"

// Forward declarations
class CSGD_Direct3D;
class CSGD_MessageSystem;
class CSGD_EventSystem;
class CSGD_TextureManager;
class CSGD_FModManager;
class CBaseMessage;
class CEvent;

class CMainMenuState : public IGameState
{
private:
	bool	m_bReset;			//	A bool to reset the main menu state for scrolling.
	int		m_nImageID;			//	The image ID for the main menu background.
	float	m_fCursorYPos;		//	Cursor Y - screen Pos.
	int		m_nCursorID;		//  The cursor image ID.
	int		m_nPlayID;
	int		m_nOptionsID;
	int		m_nLoadID;
	int		m_nExitID;
	int		m_nMenuMoveSoundID;	//	The sound ID for when the menu options are being chosen.
	int		m_nMenuEnterSoundID;//	The sound ID for when the menu option is selected.
	int		m_nSelection;		//	Used to store which menu selection is currently selected.
	RECT	m_rImageArea;		//	The area of the image top draw for the background.
	float	m_fMenuTimer;		//	A timer to help with the moving menu options.

	//static image IDs
	int staticImageID1;
	int staticImageID2;
	int staticImageID3;
	int staticImageID4;

	float m_fDelayTime;

	// Pointer for the Direct3D wrapper
	CSGD_Direct3D*			m_pD3D;
	// Pointer for the message system
	CSGD_MessageSystem*		m_pMS;
	// Pointer for the event system
	CSGD_EventSystem*		m_pES;
	// Pointer for the texture manager
	CSGD_TextureManager*	m_pTM;
	// Pointer for FMOD
	CSGD_FModManager*		m_pFM;
	CBitmapFontManager*		m_pBM;
	CBitmapFont				m_pFont;
	//int for main menu song
	int						m_nSongID;

	//////////////////////////////////////////
	// Function: "CMainMenuState"
	// Purpose:  Constructor
	//////////////////////////////////////////
	CMainMenuState();
	//////////////////////////////////////////
	// Function: "CMainMenuState"
	// Purpose:  Copy constructor
	//////////////////////////////////////////
	CMainMenuState(const CMainMenuState&);
	//////////////////////////////////////////
	// Function: "operator="
	// Purpose:  Overloaded assignment operator
	//////////////////////////////////////////
	CMainMenuState& operator=(const CMainMenuState&);
	//////////////////////////////////////////
	// Function: "~CMainMenuState"
	// Purpose:  Destructor
	//////////////////////////////////////////
	~CMainMenuState();
public:
	//////////////////////////////////////////
	// Function: "GetInstance"
	// Purpose:  Returns the instance of the 
	//			 CMainMenuState class
	//////////////////////////////////////////
	static CMainMenuState* GetInstance();

	//////////////////////////////////////////
	// Function: "Enter"
	// Purpose:  Initializes the class upon
	//			 starting to use it
	//////////////////////////////////////////
	void Enter(void);
	//////////////////////////////////////////
	// Function: "Exit"
	// Purpose:  Cleans up the class for while
	//			 it is not being used
	//////////////////////////////////////////
	void Exit(void);

	//////////////////////////////////////////
	// Function: "Input"
	// Purpose:  Handles input for the options
	//			 based on time
	//////////////////////////////////////////
	bool Input(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Update"
	// Purpose:  Updates the class based on time
	//////////////////////////////////////////
	void Update(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Render"
	// Purpose:  Draws the options menu
	//////////////////////////////////////////
	void Render(void);

	//////////////////////////////////////////
	// Function: "HandleEvent"
	// Purpose:  Handles any events concerning
	//			 the options menu
	//////////////////////////////////////////
	void HandleEvent(CEvent* pEvent);
	//////////////////////////////////////////
	// Function: "MessageProc"
	// Purpose:  Processes messages for the options menu
	//////////////////////////////////////////
	static void MessageProc(CBaseMessage* pMsg);
	//////////////////////////////////////////
	// Function: "Reset"
	// Purpose:  Resets the main menu
	//////////////////////////////////////////
	void Reset() { m_fMenuTimer = 0; }

};

#endif
